using System.Windows.Forms;
using Borland.Eco.ModelLayer.Bds;
using Borland.Studio.ToolsAPI;
using Borland.Eco.AutoContainers;
using Borland.Eco.Windows.Forms;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.ModelLayer;
using Borland.Eco.Services;
using Borland.Eco.UmlRt;
using Borland.Eco.Handles.Design;

namespace ModelAuditor
{
	public class MainForm : System.Windows.Forms.Form
	{
		private System.ComponentModel.Container components = null;
		private Borland.Eco.Handles.ReferenceHandle rhRoot;
		private Borland.Eco.WinForm.EcoActionExtender EcoGlobalActions;
		private Borland.Eco.WinForm.EcoDragDropExtender EcoDragDrop;
		private Borland.Eco.WinForm.EcoAutoFormExtender EcoAutoForms;
		private Borland.Eco.WinForm.EcoListActionExtender EcoListActions;
		private ModelAuditorEcoSpace m_EcoSpace;
		private System.Windows.Forms.DataGrid dataGrid1;
		private System.Windows.Forms.Button AddRuleButton;
		private Borland.Eco.Handles.ExpressionHandle expressionHandle1;
		private System.Windows.Forms.Button DeleteRuleButton;
		private System.Windows.Forms.Button SaveButton;
		private System.Windows.Forms.Button RunAuditButton;
		public ModelAuditorEcoSpace EcoSpace
		{
			get { return m_EcoSpace; }
		}

		#region Constructors
		public MainForm()
		{
			InitializeComponent();

			m_EcoSpace = new ModelAuditorEcoSpace();
			// Note that you need to set the EcoSpace property for each ReferenceHandle you add to the form.
			rhRoot.EcoSpace = m_EcoSpace;
			// The line below will automatically activate the ECO Space on form creation.
			// Remove the line if you wish to activate the EcoSpace manually
			m_EcoSpace.Active = true;

			IAutoContainerService svc = AutoContainerService.Instance;
			svc.AddFactory(new EditRuleFormFactory());
		}

		public MainForm(IModelService modelService, IOTAProject activeProject) : this()
		{
			m_ModelService = modelService;
			m_ActiveProject = activeProject;
			WinFormDequeuer.Active = true;

		}
		#endregion

		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			Borland.Eco.Handles.OclColumn oclColumn11 = new Borland.Eco.Handles.OclColumn();
			Borland.Eco.Handles.OclColumn oclColumn12 = new Borland.Eco.Handles.OclColumn();
			Borland.Eco.Handles.OclColumn oclColumn13 = new Borland.Eco.Handles.OclColumn();
			Borland.Eco.Handles.OclColumn oclColumn14 = new Borland.Eco.Handles.OclColumn();
			Borland.Eco.Handles.OclColumn oclColumn15 = new Borland.Eco.Handles.OclColumn();
			this.rhRoot = new Borland.Eco.Handles.ReferenceHandle();
			this.EcoListActions = new Borland.Eco.WinForm.EcoListActionExtender();
			this.AddRuleButton = new System.Windows.Forms.Button();
			this.expressionHandle1 = new Borland.Eco.Handles.ExpressionHandle();
			this.DeleteRuleButton = new System.Windows.Forms.Button();
			this.EcoDragDrop = new Borland.Eco.WinForm.EcoDragDropExtender();
			this.EcoGlobalActions = new Borland.Eco.WinForm.EcoActionExtender();
			this.SaveButton = new System.Windows.Forms.Button();
			this.EcoAutoForms = new Borland.Eco.WinForm.EcoAutoFormExtender();
			this.dataGrid1 = new System.Windows.Forms.DataGrid();
			this.RunAuditButton = new System.Windows.Forms.Button();
			((System.ComponentModel.ISupportInitialize)(this.dataGrid1)).BeginInit();
			this.SuspendLayout();
			// 
			// AddRuleButton
			// 
			this.AddRuleButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.EcoListActions.SetEcoListAction(this.AddRuleButton, Borland.Eco.WinForm.ListAction.Add);
			this.AddRuleButton.ImageIndex = 1;
			this.AddRuleButton.Location = new System.Drawing.Point(440, 8);
			this.AddRuleButton.Name = "AddRuleButton";
			this.EcoListActions.SetRootHandle(this.AddRuleButton, this.expressionHandle1);
			this.AddRuleButton.TabIndex = 1;
			this.AddRuleButton.Text = "Add";
			// 
			// expressionHandle1
			// 
			this.expressionHandle1.AddDefaultProperties = false;
			oclColumn11.Expression = "self.Name";
			oclColumn11.Name = "Name";
			oclColumn12.Expression = "self.ContextExpression";
			oclColumn12.Name = "Context";
			oclColumn13.Expression = "self.RuleExpression";
			oclColumn13.Name = "Rule";
			oclColumn14.Expression = "self.Description";
			oclColumn14.Name = "Description";
			oclColumn15.Expression = "self.Disabled";
			oclColumn15.Name = "Disabled";
			this.expressionHandle1.Columns.AddRange(new Borland.Eco.Handles.AbstractColumn[] {
						oclColumn11,
						oclColumn12,
						oclColumn13,
						oclColumn14,
						oclColumn15});
			this.expressionHandle1.Expression = "AuditRule.allInstances()";
			this.expressionHandle1.RootHandle = this.rhRoot;
			// 
			// DeleteRuleButton
			// 
			this.DeleteRuleButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.EcoListActions.SetEcoListAction(this.DeleteRuleButton, Borland.Eco.WinForm.ListAction.Delete);
			this.DeleteRuleButton.ImageIndex = 2;
			this.DeleteRuleButton.Location = new System.Drawing.Point(440, 40);
			this.DeleteRuleButton.Name = "DeleteRuleButton";
			this.EcoListActions.SetRootHandle(this.DeleteRuleButton, this.expressionHandle1);
			this.DeleteRuleButton.TabIndex = 3;
			this.DeleteRuleButton.Text = "Delete";
			// 
			// EcoGlobalActions
			// 
			this.EcoGlobalActions.RootHandle = this.rhRoot;
			// 
			// SaveButton
			// 
			this.SaveButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.EcoGlobalActions.SetEcoAction(this.SaveButton, Borland.Eco.WinForm.EcoAction.UpdateDatabase);
			this.SaveButton.Location = new System.Drawing.Point(440, 224);
			this.SaveButton.Name = "SaveButton";
			this.SaveButton.TabIndex = 4;
			this.SaveButton.Text = "Save";
			// 
			// EcoAutoForms
			// 
			this.EcoAutoForms.ShowModal = true;
			// 
			// dataGrid1
			// 
			this.dataGrid1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.dataGrid1.DataMember = "";
			this.dataGrid1.DataSource = this.expressionHandle1;
			this.EcoAutoForms.SetEcoAutoForm(this.dataGrid1, true);
			this.dataGrid1.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.dataGrid1.Location = new System.Drawing.Point(8, 8);
			this.dataGrid1.Name = "dataGrid1";
			this.dataGrid1.Size = new System.Drawing.Size(416, 240);
			this.dataGrid1.TabIndex = 0;
			// 
			// RunAuditButton
			// 
			this.RunAuditButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.RunAuditButton.Location = new System.Drawing.Point(440, 72);
			this.RunAuditButton.Name = "RunAuditButton";
			this.RunAuditButton.TabIndex = 5;
			this.RunAuditButton.Text = "Run";
			this.RunAuditButton.Click += new System.EventHandler(this.RunAuditButton_Click);
			// 
			// MainForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(528, 261);
			this.Controls.Add(this.RunAuditButton);
			this.Controls.Add(this.SaveButton);
			this.Controls.Add(this.DeleteRuleButton);
			this.Controls.Add(this.AddRuleButton);
			this.Controls.Add(this.dataGrid1);
			this.Name = "MainForm";
			this.Text = "Model Audit Rule Editor Demo Application";
			((System.ComponentModel.ISupportInitialize)(this.dataGrid1)).EndInit();
			this.ResumeLayout(false);
		}
		#endregion

		#region Private Member Variables
		public static IModelService m_ModelService;
		public static IOTAProject m_ActiveProject;
		#endregion

		#region Button Click Handlers
		private void RunAuditButton_Click(object sender, System.EventArgs e)
		{
			IObjectList rules = (IObjectList)m_EcoSpace.OclService.Evaluate("AuditRule.allInstances()");
			foreach (IObject obj in rules)
			{
				AuditRule rule = (AuditRule)obj.AsObject;
				if (!rule.Disabled)
					Evaluate(rule, CurrentModel);
			}
		}
		#endregion

		#region Evaluate Audit Rule Method
		private bool ValidateObjects(AuditRule rule, IModel model)
		{
			//Begin by evaluating the ContextExpression,
			//rendering a list of elements on which the rule will be applied
			IObjectList contextObjects = (IObjectList)model.Space.OclService.Evaluate(rule.ContextExpression);

			bool allOk = true;
			bool wroteRuleName = false;

			//Evaluate the RuleExpression on each of the resulting elements
			foreach (IObject obj in contextObjects)
			{
				bool ok = (bool)model.Space.OclService.Evaluate(obj, rule.RuleExpression).AsObject;
				if (!ok)
				{
					if (!wroteRuleName)
					{
						LogMessage(string.Format(MsgRuleFailure, rule.Name));
						wroteRuleName = true;
					}

					LogMessage(string.Format(MsgBrokenRule, obj.AsObject.GetType().Name, ((ModelElement) obj.AsObject ).Name));
					allOk = false;
				}
			}
			return allOk;
		}
		private const string MsgExpressionsBad = "Invalid rule {0}. An audit rule must contain both a Context and a Rule ocl expression!";
		private const string MsgInvalidContext = "Invalid context ocl expression in rule {0}. Context expression must evaluate to IObjectList or IObject type!";
		private const string MsgIndeterminateContext = "Unable to determine context in {0}.";
		private const string MsgRuleNotBoolean = "Invalid Rule ocl expression in rule {0}. The Rule ocl expression of an audit rule must evaluate to a boolean type!";
		private const string MsgRuleFailure = "Failures in {0}:";
		private const string MsgRuleOk = "Rule {0} evaluated OK";
		private const string MsgBrokenRule = "    {0} {1}";

		private void Evaluate(AuditRule rule, IModel m)
		{
			// Verify preconditions
			if (!rule.ExpressionsOk)
			{
				ErrorMessage(string.Format(MsgExpressionsBad, rule.Name));
				return;
			}
			IOclTypeService oclTypeService = (IOclTypeService)m.Space.GetEcoService(typeof(IOclTypeService));
			IClassifier context = oclTypeService.ExpressionType(rule.ContextExpression, null, false);

			if (context == null)
			{
				ErrorMessage(string.Format(MsgInvalidContext, rule.Name));
				return;
			}

			if (context.ClassifierType == ClassifierType.Collection)
				context = ((ICollectionType)context).ElementType;
			else if (context.ClassifierType != ClassifierType.Class)
				context = null;

			if (context == null)
			{
				ErrorMessage(string.Format(MsgIndeterminateContext, rule.Name));
				return;
			}
			IClassifier ruleUmlType = oclTypeService.ExpressionType(rule.RuleExpression, context, false);

			if (ruleUmlType == null || !ruleUmlType.EcoClassifier.ConformsTo(m.Space.TypeSystemService.TypeSystem.PredefinedTypes.Boolean))
			{
				ErrorMessage(string.Format(MsgRuleNotBoolean, rule.Name));
				return;
			}
			if (ValidateObjects(rule, m))
				LogMessage(string.Format(MsgRuleOk, rule.Name));
		}
		#endregion

		#region CurrentModel Property
		public static IModel CurrentModel
		{
			get
			{
				if (m_ActiveProject != null)
					return m_ModelService.GetModelForProject(m_ActiveProject);
				return null;
			}
		}
		#endregion

		#region Log Messaging
		private void LogMessage(string message)
		{
			MessageHelper.AddMessage(message);
		}

		private void ErrorMessage(string message)
		{
			MessageHelper.AddMessage("Error", message);
		}
		#endregion

	}
}
